#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using BROKEN = gov.va.med.vbecs.Common.VbecsBrokenRules.FrmCollectionFacilityMaintain;
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_BaseBusinessObject : BaseTest 
	{	

		private BOL.Address _tstBaseBO;
		
		private DataTable _dtFacility;

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();
			
			if (this.RefreshData)
			{
				this._dtFacility = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Facility WHERE AddressGuid IS NOT NULL", true);

				this.RefreshData = false;
			}

			//Can't initialize a new base business object (abstract).  
			//Testing it through address class.
			this._tstBaseBO = new BOL.Address();
			this._tstBaseBO.SetInitialBrokenRules(BROKEN.FormClassName, BROKEN.RuleSets.NewAddress);
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void Dispose_Pass()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Dispose_Fail()
		{
		}

		[Test]
		public void CheckIfDisposed_Pass()
		{
			this._tstBaseBO.CheckIfDisposed();
			Assert.IsTrue(true, "Method Works");
		}

		[Test]
		[ExpectedException(typeof(ObjectDisposedException))]
		public void CheckIfDisposed_Fail()
		{
			this._tstBaseBO.Dispose();
			this._tstBaseBO.CheckIfDisposed();
		}

		[Test]
		public void GetSingleBrokenRuleMessage_Pass()
		{
			string retValue = this._tstBaseBO.GetSingleBrokenRuleMessage(BROKEN.FormClassName, BROKEN.ZipCode);
			Assert.IsTrue(retValue.Length > 0, "String.Length");
		}

		[Test]
		public void GetSingleBrokenRuleMessage_Fail()
		{
			try
			{
				this._tstBaseBO.GetSingleBrokenRuleMessage(null, BROKEN.ZipCode);
				Assert.IsTrue(false, AssertionFailReasons.ArgumentNullExceptionExpected);
			}
			catch(ArgumentNullException)
			{
				Assert.IsTrue(true);
			}
			try
			{
				this._tstBaseBO.GetSingleBrokenRuleMessage(BROKEN.FormClassName, null);
				Assert.IsTrue(false, AssertionFailReasons.ArgumentNullExceptionExpected);
			}
			catch(ArgumentNullException)
			{
				Assert.IsTrue(true);
			}
		}

		[Test]
		public void IsRuleBroken_Pass()
		{
			this._tstBaseBO.StateCode = string.Empty;
			
			//ZipCode should always be a valid broken rule 
			bool retValue = this._tstBaseBO.IsRuleBroken(BROKEN.StateCode);
			
			Assert.AreEqual(true, retValue);
		}

		[Test]
		public void IsRuleBroken_Fail()
		{
			bool retValue = this._tstBaseBO.IsRuleBroken("Foot Cheese");
			
			Assert.AreEqual(false, retValue);
		}

		[Test]
		public void GetBrokenRulesMessage_Pass()
		{
			//Break one rule -- minimum
			this._tstBaseBO.City = string.Empty;

			string retValue = this._tstBaseBO.GetBrokenRulesMessage(BROKEN.FormClassName);
			Assert.IsTrue(retValue.Length > 0, "String.Length");
		}

		[Test]
		public void GetBrokenRulesMessage_Fail()
		{
			string retValue = this._tstBaseBO.GetBrokenRulesMessage("Butt Gasket");
			Assert.AreEqual(0, retValue.Length, "String.Length");
		}

		[Test]
		public void SetInitialBrokenRules_String_Pass()
		{
			BOL.Address tmpAddress = new BOL.Address();
			//Chose this FormName because it has a default RuleSet
			tmpAddress.SetInitialBrokenRules(Common.VbecsBrokenRules.FrmMaintainComments.FormClassName);

			Assert.IsTrue(tmpAddress.BrokenRulesCount > 0, "BrokenRules.Count");
		}

		[Test]
		public void SetInitialBrokenRules_String_Fail()
		{
			BOL.Address tmpAddress = new BOL.Address();
			tmpAddress.SetInitialBrokenRules("Homerpalooza");

			Assert.AreEqual(0, tmpAddress.BrokenRulesCount);
		}

		[Test]
		public void SetInitialBrokenRules_String_String_Pass()
		{
			BOL.Address tmpAddress = new BOL.Address();
			tmpAddress.SetInitialBrokenRules(BROKEN.FormClassName, BROKEN.RuleSets.NewAddress);

			Assert.IsTrue(tmpAddress.BrokenRulesCount > 0, "BrokenRules.Count");
		}

		[Test]
		public void SetInitialBrokenRules_String_String_Fail()
		{
			BOL.Address tmpAddress = new BOL.Address();
			tmpAddress.SetInitialBrokenRules("Flaming Moe", "Cough Syrup");

			Assert.AreEqual(0, tmpAddress.BrokenRulesCount);
		}

		[Test]
		public void SetInitialBrokenRules_String_String_Bool_Pass()
		{
			BOL.Address tmpAddress = new BOL.Address();

			tmpAddress.SetInitialBrokenRules(BROKEN.FormClassName, BROKEN.RuleSets.NewAddress, true);
			int allUnBroken = tmpAddress.BrokenRulesCount;

			tmpAddress.SetInitialBrokenRules(BROKEN.FormClassName, BROKEN.RuleSets.NewAddress, false);
			int noBreak = tmpAddress.BrokenRulesCount;

			Assert.IsTrue(allUnBroken < noBreak, "BrokenRules.Count");
		}

		[Test]
		public void SetInitialBrokenRules_String_String_Bool_Fail()
		{
			BOL.Address tmpAddress = new BOL.Address();
			tmpAddress.SetInitialBrokenRules("Flaming Moe", "Cough Syrup", true);

			Assert.AreEqual(0, tmpAddress.BrokenRulesCount);
		}

		[Test]
		public void IsReadOnly_Pass()
		{
			bool tstValue = !this._tstBaseBO.IsReadOnly;

			this._tstBaseBO.IsReadOnly = tstValue;
			Assert.AreEqual( tstValue, this._tstBaseBO.IsReadOnly);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsReadOnly_Fail()
		{
		}

		[Test]
		public void IsDirty_Pass()
		{
			bool tstValue = !this._tstBaseBO.IsDirty;

			this._tstBaseBO.IsDirty = tstValue;
			Assert.AreEqual(tstValue, this._tstBaseBO.IsDirty);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsDirty_Fail()
		{
		}

		[Test]
		public void BrokenRulesCount_Pass()
		{
			Assert.IsTrue(this._tstBaseBO.BrokenRulesCount > 0, "BrokenRules.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BrokenRulesCount_Fail()
		{
		}

		[Test]
		public void IsValid_Pass()
		{
			if (this._tstBaseBO.BrokenRulesCount > 0)
				Assert.AreEqual(false, this._tstBaseBO.IsValid);
			else
				Assert.IsTrue(true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsValid_Fail()
		{
		}
		
		[Test]
		public void IsNew_Pass()
		{
			bool retValue = !this._tstBaseBO.IsNew;

			this._tstBaseBO.IsNew = retValue;

			Assert.AreEqual(retValue, this._tstBaseBO.IsNew);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsNew_Fail()
		{
		}

		
		[Test]
		public void Comments_Pass()
		{
			string retValue = System.DateTime.Now.ToString();

			this._tstBaseBO.Comments = retValue;

			Assert.AreEqual(retValue, this._tstBaseBO.Comments);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Comments_Fail()
		{
		}

		[Test]
		public void LastUpdateUser_Pass()
		{
			string retValue = System.DateTime.Now.ToString();

			this._tstBaseBO.LastUpdateUser = retValue;

			Assert.AreEqual(retValue, this._tstBaseBO.LastUpdateUser);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LastUpdateUser_Fail()
		{
		}


		[Test]
		public void LastUpdateDate_Pass()
		{
			System.DateTime retValue = System.DateTime.Now;

			this._tstBaseBO.LastUpdateDate = retValue;

			Assert.AreEqual(retValue, this._tstBaseBO.LastUpdateDate);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LastUpdateDate_Fail()
		{
		}


		[Test]
		public void RecordStatusText_Pass()
		{
			string retValue = System.DateTime.Now.ToString();

			this._tstBaseBO.RecordStatusText = retValue;

			Assert.AreEqual(retValue, this._tstBaseBO.RecordStatusText);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RecordStatusText_Fail()
		{
		}

		[Test]
		public void RowVersion_Pass()
		{
			byte[] retValue = (byte[])this._dtFacility.Rows[0][TABLES.Facility.RowVersion];

			this._tstBaseBO.RowVersion = retValue;

			Assert.AreEqual(retValue, this._tstBaseBO.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RowVersion_Fail()
		{
		}

		
		[Test]
		public void Clone_Pass()
		{
			System.Guid facilityGuid = (System.Guid)this._dtFacility.Rows[0][TABLES.Facility.FacilityGuid];

			BOL.Address tmpAddress = new BOL.Address(facilityGuid);

			BOL.Address tmpClone = (BOL.Address)tmpAddress.Clone();

			Assert.AreEqual(tmpAddress.AddressLine1, tmpClone.AddressLine1);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Clone_Fail()
		{
		}


	}
}
#endif
